/************************************************************************************
* This file is owned by the application software and basically defines how the 
* HCS08 platform is configured. The file is included by the relevant Platform
* modules and is necessary for the MAC to compile.
*
* Author(s): Knud Dyring-Olsen, Jesper Thomsen
*
* (c) Copyright 2005, Freescale, Inc.  All rights reserved.
*
* Freescale Confidential Proprietary
* Digianswer Confidential
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale.
*
* Last Inspected:
* Last Tested:
************************************************************************************
* History:
*	10/13/06 - For FFD-stack:	The gTotalSmallMsgs_d samll stack size changed from 5 to 250
*								The gTotalBigMsgs_d	  large stack size changed from 5 to 250
*
************************************************************************************/
#ifndef _APPTOMACPHYCONFIG_H_
	#define _APPTOMACPHYCONFIG_H_

#include "hprfgw_rfdesc.h"

//**********************************************************************************
//**********************************************************************************
// Select one device type per below. 
// If none selected default type is Type_FFD (all features). The type can be
// defined by the build environment (compiler settings).
//**********************************************************************************
//**********************************************************************************
//#define Type_RFDNBNS
//#define Type_RFDNBNV
//#define Type_RFDNB
//#define Type_RFD
//#define Type_FFDNBNS
//#define Type_FFDNBNV
//#define Type_FFDNB
//#define Type_FFDNGTS
//#define Type_FFD
//#define Type_FFDPNBNV
#if !defined(Type_RFDNBNS) && !defined(Type_RFDNBNV) && !defined(Type_RFDNB) && !defined(Type_RFD) && !defined(Type_FFDNBNS) && \
    !defined(Type_FFDNBNV) && !defined(Type_FFDNB) && !defined(Type_FFDNGTS) && !defined(Type_FFD) && !defined(Type_FFDPNBNV)
#define Type_FFD
#endif // Type_***


//**********************************************************************************
//**********************************************************************************
// Define MAC buffer pools depending on device type. The number of buffers in each
// pool depends on the supported features. The device type also determines
// whether or not ACL buffers must be allocated for MAC security.
//**********************************************************************************
//**********************************************************************************
#if defined(Type_RFDNB) || defined(Type_RFDNBNV)
  // Reduced Function Device, no beacons (NB), no MLME parameter verification (NV).
  #define gBigMsgsMacOnly_d         0 // No MAC private pool
  #define gMmNumPools_c             2 // One small + one large buffer pool
  #define gTotalSmallMsgs_d         5 // Number of control messages
  #define gTotalBigMsgs_d           3 // Number of data messages
  #define gNumAclEntryDescriptors_c 4 // Number of ACL entries in MAC PIB
#endif

#if defined(Type_RFDNBNS)
  // Reduced Function Device, no beacons (NB), no MAC security (NS).
  #define gBigMsgsMacOnly_d         0 // No MAC private pool
  #define gMmNumPools_c             2 // One small + one large buffer pool
  #define gTotalSmallMsgs_d         5 // Number of control messages
  #define gTotalBigMsgs_d           3 // Number of data messages
  #define gNumAclEntryDescriptors_c 0 // No security -> no ACL entries.
#endif

#if defined(Type_RFD)
  // Reduced Function Device (end-device only).
  #define gBigMsgsMacOnly_d         0 // No MAC private pool
  #define gMmNumPools_c             2 // One small + one large buffer pool
  #define gTotalSmallMsgs_d         5 // Number of control messages
  #define gTotalBigMsgs_d           4 // Number of data messages
  #define gNumAclEntryDescriptors_c 4 // Number of ACL entries in MAC PIB
#endif

#if defined(Type_FFDNB) || defined(Type_FFDNBNV) || defined(Type_FFDPNBNV)
  // Full Function Device, no beacons (NB), no MLME parameter verification (NV), 
  // PAN Coordinator Only (P).
  #define gBigMsgsMacOnly_d         1 // One buffer is MAC private.
  #define gMmNumPools_c             3 // One small + one large + one large MAC private buffer pool
  #define gTotalSmallMsgs_d         5 // Number of control messages
  #define gTotalBigMsgs_d           4 // Number of data messages
  #define gNumAclEntryDescriptors_c 4 // Number of ACL entries in MAC PIB
#endif

#if defined(Type_FFDNBNS)
  // Full Function Device, no beacons (NB), no MAC security (NS), 
  #define gBigMsgsMacOnly_d         1 // One buffer is MAC private.
  #define gMmNumPools_c             3 // One small + one large + one large MAC private buffer pool
  #define gTotalSmallMsgs_d         5 // Number of control messages
  #define gTotalBigMsgs_d           4 // Number of data messages
  #define gNumAclEntryDescriptors_c 0 // No security -> no ACL entries.
#endif 

#if defined(Type_FFD) || defined(Type_FFDNGTS)
  // Full Function Device, no GTS (NGTS), 
  #define gBigMsgsMacOnly_d         1 	// One buffer is MAC private.
  #define gMmNumPools_c             3 	// One small + one large + one large MAC private buffer pool

#ifdef	RF_NETWORK_MASTER_DEVICE
  #define gTotalSmallMsgs_d         250	// Number of control messages
  #define gTotalBigMsgs_d           250	// Number of data messages
#else
  #define gTotalSmallMsgs_d         5	// Number of control messages
  #define gTotalBigMsgs_d           5	// Number of data messages
#endif

  #define gNumAclEntryDescriptors_c 4 	// Number of ACL entries in MAC PIB
#endif 


  // Allows application to select if ASP shall be included
#define gAspCapability_d             1
  // Telec functionality for the Japanese market
#define gAspJapanTelecCapability_d  (1 && gAspCapability_d)

#endif /* _APPTOMACPHYCONFIG_H_ */
